/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASEvent;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIMaskChangeListener;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASObject;
import com.ibm.ras.RASTraceEvent;
import com.ibm.ras.RASTraceFormatter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RASHandler
extends RASObject
implements RASIHandler,
Runnable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public boolean deviceOpen = false;
    private boolean done = false;
    private boolean stopRequested = false;
    protected Hashtable formatters = new Hashtable();
    private long messageMask = 7L;
    private long traceMask = 2047L;
    protected PrintWriter pWriter;
    private Vector logQueue = new Vector(25, 25);
    private Vector maskChangeListeners = new Vector();

    public RASHandler() {
        this("", "");
    }

    public RASHandler(String string) {
        this(string, "");
    }

    public RASHandler(String string, String string2) {
        super(string, string2);
        this.addFormatter(new RASMessageFormatter());
        this.addFormatter(new RASTraceFormatter());
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName(String.valueOf(this.getClass().getName()) + ":" + this.getName());
        thread.start();
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("messageMask", RASMessageEvent.maskToString(this.getMessageMask()));
        hashtable.put("traceMask", RASTraceEvent.maskToString(this.getTraceMask()));
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("messageMask")) {
            this.setMessageMask(RASMessageEvent.maskLongValue((String)hashtable.get("messageMask")));
        }
        if (hashtable.containsKey("traceMask")) {
            this.setTraceMask(RASTraceEvent.maskLongValue((String)hashtable.get("traceMask")));
        }
    }

    public long getMessageMask() {
        return this.messageMask;
    }

    public void setMessageMask(long l) {
        this.messageMask = l;
        this.fireMaskChangedEvent();
    }

    public long getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(long l) {
        this.traceMask = l;
        this.fireMaskChangedEvent();
    }

    protected void fireMaskChangedEvent() {
        Enumeration enumeration = this.getMaskChangeListeners();
        while (enumeration.hasMoreElements()) {
            RASIMaskChangeListener rASIMaskChangeListener = (RASIMaskChangeListener)enumeration.nextElement();
            rASIMaskChangeListener.maskValueChanged();
        }
    }

    public void addMaskChangeListener(RASIMaskChangeListener rASIMaskChangeListener) {
        if (rASIMaskChangeListener != null && !this.maskChangeListeners.contains(rASIMaskChangeListener)) {
            this.maskChangeListeners.addElement(rASIMaskChangeListener);
        }
    }

    public void removeMaskChangeListener(RASIMaskChangeListener rASIMaskChangeListener) {
        if (rASIMaskChangeListener != null && this.maskChangeListeners.contains(rASIMaskChangeListener)) {
            this.maskChangeListeners.removeElement(rASIMaskChangeListener);
        }
    }

    public Enumeration getMaskChangeListeners() {
        return this.maskChangeListeners.elements();
    }

    public void addFormatter(RASIFormatter rASIFormatter) {
        if (rASIFormatter != null) {
            Enumeration enumeration = rASIFormatter.getEventClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.put(string, rASIFormatter);
            }
        }
    }

    public void removeFormatter(RASIFormatter rASIFormatter) {
        if (rASIFormatter != null) {
            Enumeration enumeration = rASIFormatter.getEventClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.remove(string);
            }
        }
    }

    public Enumeration getFormatters() {
        return this.formatters.elements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.done) {
            RASEvent rASEvent;
            Vector vector = this.logQueue;
            synchronized (vector) {
                while (true) {
                    if (!this.logQueue.isEmpty() || this.stopRequested) {
                        rASEvent = null;
                        if (!this.logQueue.isEmpty()) {
                            rASEvent = (RASEvent)this.logQueue.firstElement();
                            this.logQueue.removeElementAt(0);
                        }
                        this.logQueue.notify();
                        break;
                    }
                    try {
                        this.logQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (rASEvent != null) {
                this.writeEvent(rASEvent);
                continue;
            }
            vector = this.logQueue;
            synchronized (vector) {
                if (this.stopRequested) {
                    this.done = true;
                    this.logQueue.notify();
                }
            }
        }
    }

    public void stop() {
        Vector vector = this.logQueue;
        synchronized (vector) {
            this.stopRequested = true;
            this.logQueue.notify();
            while (!this.done) {
                try {
                    this.logQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public abstract void openDevice();

    public void logEvent(RASIEvent rASIEvent) {
        if (rASIEvent != null) {
            Vector vector = this.logQueue;
            synchronized (vector) {
                this.logQueue.addElement(rASIEvent);
                this.logQueue.notify();
                return;
            }
        }
    }

    public void writeEvent(RASIEvent rASIEvent) {
        RASIFormatter rASIFormatter;
        if (!this.deviceOpen) {
            this.openDevice();
        }
        if (this.deviceOpen && (rASIFormatter = this.findFormatter(rASIEvent)) != null) {
            String string = rASIFormatter.format(rASIEvent);
            this.pWriter.println(string);
        }
    }

    protected RASIFormatter findFormatter(RASIEvent rASIEvent) {
        boolean bl = false;
        Class<?> clazz = rASIEvent.getClass();
        RASIFormatter rASIFormatter = null;
        while (!bl && clazz != null) {
            String string = clazz.getName();
            if (this.formatters.containsKey(string)) {
                bl = true;
                rASIFormatter = (RASIFormatter)this.formatters.get(string);
                continue;
            }
            clazz = clazz.getSuperclass();
        }
        return rASIFormatter;
    }
}

